package kom.itbeankit.nw.ethernet;

import java.lang.*;
public class BusElementStatus   extends java.lang.Object
                                implements EthernetInterface
{
    public BusElementStatus(){
    	fromLeftDataEvent   = null;
    	fromRightDataEvent  = null;
    	fromTopDataEvent    = null;
    	fromBottomDataEvent = null;
    }
    
	public BusElementStatus(BusElementStatus s){
    	fromLeftDataEvent   = s.fromLeftDataEvent;
    	fromRightDataEvent  = s.fromRightDataEvent;
    	fromTopDataEvent    = s.fromTopDataEvent;
    	fromBottomDataEvent = s.fromBottomDataEvent;
	}


	public int getDataType(){
	    int returnValue = 0;
	    if(fromLeftDataEvent!=null)
	        returnValue += fromLeftDataEvent.getDataType();
	    if(fromRightDataEvent!=null)
	        returnValue += fromRightDataEvent.getDataType();
	    if(fromTopDataEvent!=null)
	        returnValue += fromTopDataEvent.getDataType();
	    if(fromBottomDataEvent!=null)
	        returnValue += fromBottomDataEvent.getDataType();

	    
	    //if more than one has data received
	    //or if one of them is collision
	    //return collision
	    if(returnValue >= DATA_TYPE_COLLISION)
	        returnValue = DATA_TYPE_COLLISION;
	        
	    return returnValue;    
	}
	
	public void setStatus(BusElementStatus s){
    	fromLeftDataEvent   = s.fromLeftDataEvent;
    	fromRightDataEvent  = s.fromRightDataEvent;
    	fromTopDataEvent    = s.fromTopDataEvent;
    	fromBottomDataEvent = s.fromBottomDataEvent;
	}
	
	public DataEvent fromLeftDataEvent;
	public DataEvent fromRightDataEvent;
	public DataEvent fromTopDataEvent;
	public DataEvent fromBottomDataEvent;	
}